class R97():
    def __init__(self):
        self._d = [0,0,0,0,0,0,0,0,0,0,0,0,0,0]

class HP97():
    _op_arith = ('0 -> a[%s]', '0 -> b[%s]',
                 'a <-> b[%s]', 'a -> b[%s]',
                 'a <-> c[%s]', 'c -> a[%s]',
                 'b -> c[%s]', 'b <-> c[%s]',
                 '0 -> c[%s]', 'a + b -> a[%s]',
                 'a + c -> a[%s]', 'c + c -> c[%s]',
                 'a + c -> c[%s]', 'a + 1 -> a[%s]',
                 'shift left a[%s]', 'c + 1 -> c[%s]',
                 'a - b -> a[%s]', 'a - c -> c[%s]',
                 'a - 1 -> a[%s]', 'c - 1 -> c[%s]',
                 '0 - c -> c[%s]', '0 - c - 1 -> c[%s]',
                 'if b[%s] = 0', 'if c[%s] = 0',
                 'if a >= c[%s]', 'if a >= b[%s]',
                 'if a[%s] # 0', 'if c[%s] # 0',
                 'a - c -> a[%s]', 'shift right a[%s]',
                 'shift right b[%s]', 'shift right c[%s]')
    _p_test = (4,8,12,2,9,1,6,3,1,13,5,0,11,10,7,4)
    _p_set = (14,4,7,8,11,2,10,12,1,3,13,6,0,9,5,14)

    def __init__(self, romfile):
        self._A = 0x0000000
        self._B = 0x0000000
        self._C = 0x0000000
        self._Y = 0x0000000
        self._Z = 0x0000000
        self._T = 0x0000000
        self._M2 = 0x0000000
        self._M1 = 0x0000000
        self._F = 0x0
        self._P = 0x0
        self._S = 0x0000
        self._CY = 0
        self._DEC = 1
        self._EF = 0x0000
        self._bank = 0;
        self._stack = {}
        self._del_rom = 0x00
        self._del_rom_fl = 0
        self._de = 0
        self._addr = 0x00
        self._rom = {}

        self._desass_del_rom = 0x00
        self._desass_del_rom_f = 0
        self._desass_test = 0

        f = open(romfile, 'rt')
        for l in f:
            if (len(l)>1):
                if (l[0] == '['):
                    if (l[2] == ']'):
                        bank = l[1]
                        n = 3
                    else:
                        bank = l[1:2]
                        n = 4
                    address = int(l[n:n+4], 8)
                    code = int(l[n+5:n+9], 8)
                    label0  = 'L%05X' % address
                    label1  = 'L%05X' % ((1 << 12) | address)
                    desass = self._op_desass(code, address)
                    comment = ''
                    if (bank == '01'):
                        self._add(0, address, label0, code, desass, comment)
                    elif (bank == '0'):
                        self._add(0, address, label0, code, desass, comment)
                    elif (bank == '1'):
                        self._add(1, address, label1, code, desass, comment)
        f.close()
        
    def _misc(self, op, i):
        if (op == 0x0):          
            if (i == 0x0):
                return 'nop'
            elif (i == 0x1):
                return 'crc motor on?'
            elif (i == 0x3):
                return 'crc test f1'
            elif (i == 0x5):
                return 'crc test f2'
            elif (i == 0x7):
                return 'crc test f3'
            elif (i == 0x9):
                return 'crc test f4'
            elif (i == 0xA):
                return 'crc set f0'
            elif (i == 0xB):
                return 'crc clear f0'
            elif (i == 0xC):
                return 'crc set f1'
            elif (i == 0xD):
                return 'crc clear f1'
            elif (i == 0xF):
                return 'crc wr prot?'
            else:
                return 'crc ?%1X%1X?' % (i, op,) 
        elif (op == 0x01):
            return '1 -> S%d' % i
        elif (op == 0x02):
            return ('clear reg', 'clear s', 'display toggle', 'display off',
                    'm1 <-> c', 'm1 -> c', 'm2 <-> c', 'm2 -> c',
                    'stack -> a', 'down rotate', 'y -> a', 'c -> stack',
                    'decimal', 'unknown D2', 'f -> a', 'f <-> a')[i]
        elif (op == 0x03):
            return '0 -> S%d' % i
        elif (op == 0x04):
            return ('keys -> rom addr', 'keys -> a', 'a -> rom addr',
                    'display reset twf', 'binary', 'circulate a left',
                    'p - 1 > p', 'p + 1 -> p', 'return',
                    'pik home?', 'pik cr?', 'pik keys?', 'pik ?C4?',
                    'pik ?D4?', 'pik ?E4?', 'pik print3')[i]
        elif (op == 0x05):
            self._desass_test = 1
            return 'if S%d = 1' % i
        elif (op == 0x06):
            return 'load constant %d' % i
        elif (op == 0x07):
            return 'if S%d = 0' % i
        elif (op == 0x08):
            return 'sel rom %X' % i
        elif (op == 0x09):
            return 'if p = %d' % HP97._p_test[i]
        elif (op == 0x0A):
            return 'c -> data r%d' % i
        elif (op == 0x0B):
            return 'if p # %d' % HP97._p_test[i]
        elif (op == 0x0C):
            return ('crc ?0C?', 'crc ?1C?', 'crc motor on', 'crc motor off',
                    'crc ?4C?', 'crc card in?', 'crc test prot', 'crc ?7C?',
                    'bank switch', 'c -> addr', 'clear data regs',
                    'c -> data', 'rom selftest',
                    'crc ?DC?', 'pik print6', "hi i'm woodstock")[i]
        elif (op == 0x0D):
            self._desass_del_rom = i
            self._desass_del_rom_f = 1
            return 'del sel rom %X' % i
        elif (op == 0x0E):
            return 'data r %d -> c' % i
        else:
            return 'p <- %d' % HP97._p_set[i]

    def _arith(self, op, tef):
        return self._op_arith[op] % self._tef(tef)

    def _tef(self, tef):
        return ('p', 'wp', 'xs', 'x', 's', 'm', 'w', 'ms')[tef]

    def _op_desass(self, op, address):
        op_class = op & 0x003
        op_tef = (op >> 2) & 0x07
        op_op = (op >> 5)
        op_jp = (op >> 2)
        if (self._desass_test == 1):
            self._desass_test = 0
            rom = ((address >> 10 ) << 2) | (op >> 8)
            _op = '  then go to %X %02X' % (rom, op & 0xFF,)
        else:
            if (self._desass_del_rom_f == 1):
                rom = self._desass_del_rom
                self._desass_del_rom_f = 0
            else:
                rom = address >> 8
            if   (op_class == 0x0):         # class 0 misc
                _op = self._misc((op >> 2) & 0x0F, (op >> 6))
                if (_op[0:3] == 'if '):
                    self._desass_test = 1
            elif (op_class == 0x2):         # class 2 arith
                _op = self._arith(op_op, op_tef)
                if (_op[0:3] == 'if '):
                    self._desass_test = 1
            elif (op_class == 0x1):         # class 1 jsb
                _op = 'jsb %X %02X' % (rom, op_jp,)
            else:                           # class 3 go to
                _op = 'if n/c go to %X %02X' % (rom, op_jp,)

        return _op
        
    def _op_do(self, op):
        op_class = op & 0x002
        op_fet = (op >> 2) & 0x07
        op_op = (op >> 5) 
        if   (op_class == 0x0):       # class 0 misc
            pass
        elif (op_class == 0x2):       # class 2 arith
            pass
        elif (op_class == 0x1):       # class 1 jsb
            pass
        else:       # class 3 go to
            pass
        
    def _add(self, bank, address, label, code, text, comment):
        _text = text + ' '*20
        self._rom[(bank << 12) | address] = (label, code, _text[0:19])
#        _comment = comment + ' '*38
#        self._rom[(bank << 12) | address] = (label, code, _text[0:19], _comment[0:37])

    def dump(self, filename, comments0, comments1):
        f = open(filename, 'wt')
        c0 = open(comments0, 'rt')
        lc0 = c0.readlines()
        c0.close()
        c1 = open(comments1, 'rt')
        lc1 = c1.readlines()
        c1.close()
        n = 1
        for i in range(0, 1<<12):
            if i in self._rom.keys():
                l = '%05d ' % n
                if (n <= len(lc0)):
                    com = lc0[n-1][:-1]
                else:
                    com = ''
                com = com + ' '*39                
                l = l + '%s:  %03X   %s' % self._rom[i]
                l = l + com[0:37]
                if ((i + (1<<12)) in self._rom.keys()) and (self._rom[i + (1<<12)] != ''):
                    if (n <= len(lc1)):
                        com = lc1[n-1][:-1]
                    else:
                        com = ''
                    com = com + ' '*39
                    l = l + '  %s:  %03X   %s' % self._rom[i | (1<<12)]
                    l = l + com[0:37]
                f.write(l+'\n')
                n = n + 1
        f.close()
                    
    def dump_rom67(self, filename0, filename1):
        f = open(filename0, 'wb')
        for i in range(0, 4096):
            code = self._rom[i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        f.close()
        f = open(filename1, 'wb')
        for i in range(0,1024):
            code = self._rom[i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        for i in range(1024, 2048):
            code = self._rom[4096 + i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        for i in range(2048, 4096):
            code = self._rom[i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        f.close()
                    
    def dump_rom97(self, filename0, filename1):
        f = open(filename0, 'wb')
        for i in range(0, 4096):
            code = self._rom[i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        f.close()
        f = open(filename1, 'wb')
        for i in range(0,1024):
            code = self._rom[i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        for i in range(1024, 3072):
            code = self._rom[4096 + i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        for i in range(3072, 4096):
            code = self._rom[i][1]
            f.write(chr(code % 256))
            f.write(chr(code >> 8))
        f.close()
 
topcat = HP97('67.obj.txt')
topcat.dump('67.obj.lst', '67.com0.txt', '67.com1.txt')
topcat.dump_rom67('67_bank0.bin','67_bank1.bin')

#topcat = HP97('97.obj.txt')
#topcat.dump('97.obj.lst', '97.com0.txt', '97.com1.txt')
#topcat.dump_rom97('97_bank0.bin','97_bank1.bin')

